IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_WebProcesos_Pendientes') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_WebProcesos_Pendientes
END
GO

CREATE PROCEDURE [dbo].[CPJ_WebProcesos_Pendientes] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parámetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Cliente			INT
DECLARE @pId_Cliente_Titular	INT

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Cliente				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Cliente_Titular		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente_Titular')), 0)
/*FIN Variables recibidas por parámetro a traves del JSON*/

	/***************************************************************************************************

	Procedimiento:      dbo.CPJ_WebProcesos_Pendientes
	Fecha de Creacion:  2023-07-18
	Creado por:         Adriana Laverde
	Descripcion:        Procedimiento encargado de chequeo y generacion de WebProcesos en Estado 1
	Llamado por:        [Kiosk][Tickets.php]
	Tablas afectadas:   [Cbtes],[Cbtes_Items],[WebProcesos]
	Usado en:           Kiosk - Venta de Entradas
	Parametro(s):       @pJson - Json con parametros FlagUsarTrans, ModoDebug, Id_Cliente
	Forma de uso:       EXEC dbo.CPJ_WebProcesos_Pendientes '{"FlagUsarTrans":"0","ModoDebug":"1","Id_Cliente":"2716"}'
	Notas adicionales:  

	ORDEN y GUIA DE EJECUCION:
	1) Verificacion de WebProceso en Estado 1 en un periodo de +60 segundos a la fecha que se ingresa al procedimiento 

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------
	2023-07-31			F. Gonzalez			Se modifica el intervalo de -30 a -60 para operaciones
						A. Laverde			recien creadas. (linea 454)
							
              
	***************************************************************************************************/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @Result_Tabla_Stored_Invocado TABLE (ErrorNumber	INT,
											ErrorSeverity	INT,
											ErrorState		INT,
											ErrorProcedure  VARCHAR(1000),
											ErrorLine		INT,
											ErrorMessage	VARCHAR(4000))
/*FIN Variable de Retorono del Stored*/

/*Declaracion de Variables*/
DECLARE @Id_Web_Proceso						INT		
DECLARE @Json								VARCHAR(8000)
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @rta_JSON_Stored_Invocado			VARCHAR(8000)
DECLARE @Nro_Operacion						VARCHAR(100)
DECLARE @Fecha_Procesamiento				DATETIME
DECLARE @Id_Tipo_Cbte_Fac					CHAR(4)
DECLARE @Id_Tipo_Cbte_Rec					CHAR(4)
DECLARE @Id_Cond_Pago						SMALLINT
DECLARE @Id_Moneda							CHAR(3)
DECLARE @Id_Lista_Precio					SMALLINT
DECLARE @Id_Trans_Fac						INT
DECLARE @Id_Trans_Rec						INT
DECLARE	@Json_Prod							VARCHAR(8000)
DECLARE @Cant								SMALLINT
DECLARE @Contador							INT = 1;
DECLARE @Id_Cliente							INT
DECLARE @Importe							DECIMAL(20,2)
DECLARE @Id_Producto						VARCHAR(14)
DECLARE @Fecha_QA							DATETIME
DECLARE @Fecha_Venc							DATETIME
DECLARE @Cantidad							DECIMAL(15,5)
DECLARE @Id_Periodo_Caja					INT
DECLARE @Precio_Grav						DECIMAL(20,2)
DECLARE @Id_Cta_banco						INT
DECLARE @Tipo_Operacion						VARCHAR(1)
DECLARE @Genera_Factura						SMALLINT
DECLARE @Flag_Entrada_Ya_Adquirida			TINYINT
DECLARE @Evento_Id_Evento_Grupo				INT
DECLARE @Importe_Rec						DECIMAL(20,2)
DECLARE @Descripcion						VARCHAR(150)
DECLARE @Razon_Social						VARCHAR(100)

/*FIN Declaracion de Variables*/

IF (@pId_Cliente > 0)
BEGIN

	IF @pModoDebug = 1
	BEGIN
		PRINT 'Id_Socio: '	+ CAST(@pId_Cliente AS VARCHAR(10))
	END
	
		SET @Id_Web_Proceso = ISNULL((SELECT MAX(Id_Web_Proceso)
							  FROM WebProcesos W
							  WHERE DATEADD(SECOND, 60, W.Fecha_Procesamiento) <= GETDATE()
							  AND ISNULL(dbo.CF_JSON_VALUE(CAST(W.Json AS NVARCHAR(MAX)), '$.productos[0].id_cliente'),W.Id_Cliente) = @pId_Cliente
							  AND W.Id_Cliente = @pId_Cliente_Titular
							  AND W.Id_Estado = 1
							  AND W.Fecha_Creacion >= '20230801'
							  GROUP BY Id_Web_Proceso),0)

	IF (@Id_Web_Proceso > 0)
	BEGIN

			SELECT @Json		   = JSON
				  ,@Nro_Operacion  = Nro_Operacion
				  ,@Tipo_Operacion = Tipo_Operacion
			FROM WebProcesos
			WHERE Id_Web_Proceso = @Id_Web_Proceso

			IF (@Tipo_Operacion = 'P')
			BEGIN
				SET @Genera_Factura = 1
				SET @Json_Prod			= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@Json,'productos')), '')
			END
			ELSE
			BEGIN
				SET @Json_Prod			= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@Json,'transacciones')), '')
			END
			
			SELECT * INTO #TABLE FROM dbo.CF_Split(@Json_Prod,'},')
			SET @Cant				= (SELECT COUNT(*) FROM #TABLE)

			SET @Importe			= ISNULL(CONVERT(DECIMAL(20,2), dbo.CF_JSON_VALUE(@Json,'imp_total')), 0)
				IF (@Importe = 0)
				BEGIN
					SET @Importe	 = ISNULL(CONVERT(DECIMAL(20,2), dbo.CF_JSON_VALUE(@Json,'total')), 0)
				END
			SET @Importe_Rec = @Importe

			SET @Id_Lista_Precio	= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@Json,'id_lista_precio')), 0)

			IF @pModoDebug = 1
			BEGIN
				PRINT 'Posee un Proceso Pendiente de +30 segundos'	
				PRINT 'Id_Web_Proceso: ' + CAST(@Id_Web_Proceso AS VARCHAR(10))
				PRINT 'Tipo de Operacion: ' + CAST(@Tipo_Operacion AS VARCHAR(10))
				PRINT 'Cant: ' + CAST(@Cant AS VARCHAR(10))
				PRINT 'Importe: ' + CAST(@Importe AS VARCHAR(10))
				PRINT 'Id_Lista_Precio: ' + CAST(@Id_Lista_Precio AS VARCHAR(10))
			END

			SET @Id_Tipo_Cbte_Fac	= dbo.CF_xParam('Tipo_Cbte_VW_Factura')
			SET @Id_Tipo_Cbte_Rec	= dbo.CF_xParam('Tipo_Cbte_VW_Recibo')
			SET @Id_Cond_Pago		= dbo.CF_xParam('Cond_Pago_CTACTE')
			SET @Id_Moneda			= dbo.CF_xParam('Moneda_Cbte_VW')
			SET @Id_Periodo_Caja	= dbo.CF_xParam('Per_Caja_Cob_Web')
			SET @Id_Cta_banco	    = dbo.CF_xParam('Id_Cta_Baco_CWeb')

			

			SET @Evento_Id_Evento_Grupo = ISNULL((SELECT ISNULL(Id_Evento_Grupo,0) FROM Prod_Listas_Precios WHERE Id_Lista_Precio = @Id_Lista_Precio),0)

			SET @Flag_Entrada_Ya_Adquirida = ISNULL((SELECT TOP 1 1
											  FROM Cbtes_Items CI LEFT JOIN Cbtes C	ON CI.Id_Trans = C.Id_Trans
											  					LEFT JOIN Productos P	ON CI.Id_Producto = P.Id_Producto
											  					LEFT JOIN Cbtes_Tipos CT	ON C.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
											  					LEFT JOIN Prod_Listas_Precios PL	ON C.Id_Lista = PL.Id_Lista_Precio
											  WHERE 
											  CI.Id_Cliente = @pId_Cliente
											  AND P.Tipo = 'L'
											  AND PL.Activo = 1
											  AND CI.Fecha_Venc >= GETDATE()
											  AND PL.Id_Evento_Grupo in (@Evento_Id_Evento_Grupo)
											  AND (CT.Compromete_Factura = 1 OR CT.Compromete_Pedido = 1)
											  AND C.Id_Estado_Cbte NOT IN (3)),0)
			
			IF (@Flag_Entrada_Ya_Adquirida = 0)
			BEGIN
			-------------------------------------------- GENERACION DE FACTURA --------------------------------------------
			IF (@Genera_Factura = 1)
			BEGIN

				IF(@pModoDebug = 1)
				BEGIN
					PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar'
				END

					SET @JSON_Parametros_Stored_Invocado =	'{' +
															dbo.CF_Json_ParsearVariable('FlagUsarTrans', @pFlagUsarTrans, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Usuario', -1, 'SMALLINT') + ',' +
															dbo.CF_Json_ParsearVariable('Lote', @Nro_Operacion, 'VARCHAR(20)') + ',' +
															dbo.CF_Json_ParsearVariable('Fecha', GETDATE(), 'DATETIME') + ',' +
															dbo.CF_Json_ParsearVariable('FechaVence', GETDATE(), 'DATETIME') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Cliente', @pId_Cliente, 'INT') + ',' +	
															dbo.CF_Json_ParsearVariable('Id_Tipo_Cbte', @Id_Tipo_Cbte_Fac, 'CHAR(4)') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Moneda', @Id_Moneda, 'CHAR(3)') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Lista_Precio', @Id_Lista_Precio, 'SMALLINT') + ',' +
															dbo.CF_Json_ParsearVariable('Refacturar', 1, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('Cotizacion', 1, 'DECIMAL(12,4)') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Contrato', 0, 'INT') +  
															'}'

					SET @Id_Trans_Fac = 0
					DELETE @Result_Tabla_Stored_Invocado
	
					INSERT INTO @Result_Tabla_Stored_Invocado
					EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar @JSON_Parametros_Stored_Invocado

					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
					BEGIN
						RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar', 16,  1 ) 
					END
					ELSE
					BEGIN
						SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
						SET @Id_Trans_Fac = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@rta_JSON_Stored_Invocado,'id_trans')), 0)
					END

				IF(@pModoDebug = 1)
				BEGIN
					PRINT 'Id_Trans_Fac: ' + CAST(@Id_Trans_Fac AS VARCHAR(10))
				END
				-------------------------------------------- FIN GENERACION DE FACTURA --------------------------------------------

				------------------------------------------- GENERACION DE ITEMS FACTURA -------------------------------------------
				IF(@Id_Trans_Fac > 0)
				BEGIN

					IF(@pModoDebug = 1)
					BEGIN
						PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item'
					END

						WHILE @Contador <= @Cant
						BEGIN
							SET @Precio_Grav = (SELECT dbo.CF_JSON_VALUE(ColumnA,'importe') FROM #TABLE WHERE Id = @Contador)
							SET @Id_Producto = (SELECT dbo.CF_JSON_VALUE(ColumnA,'id_producto') FROM #TABLE WHERE Id = @Contador)
							SET @Fecha_QA	 = (SELECT CONVERT(DATE,dbo.CF_JSON_VALUE(ColumnA,'desde')) FROM #TABLE WHERE Id = @Contador)
							SET @Fecha_Venc	 = (SELECT CONVERT(DATE,dbo.CF_JSON_VALUE(ColumnA,'hasta')) FROM #TABLE WHERE Id = @Contador)
							SET @Id_Cliente	 = (SELECT dbo.CF_JSON_VALUE(ColumnA,'id_cliente') FROM #TABLE WHERE Id = @Contador)
							SET @Cantidad	 = (SELECT dbo.CF_JSON_VALUE(ColumnA,'cantidad') FROM #TABLE WHERE Id = @Contador)
				
							SET @json =	'{'
							SET @json =	@json + '"FlagUsarTrans":"' + CONVERT(VARCHAR(10), @pFlagUsarTrans) +'"'
							SET @json =	@json +	',"ModoDebug":"' + CONVERT(VARCHAR(10), @pModoDebug) +'"'
							SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Fac) +'"'
							SET @json =	@json +	',"Id_Cliente":"' + CONVERT(VARCHAR(10), @Id_Cliente) +'"'
							SET @json =	@json +	',"Id_Producto":"' + CONVERT(VARCHAR(14), @Id_Producto) +'"'
							SET @json =	@json +	',"Cantidad":"' + CONVERT(VARCHAR(10), @Cantidad) +'"'
							SET @json =	@json +	',"Precio_Grav":"' + CONVERT(VARCHAR(20), @Precio_Grav) +'"'
							SET @json =	@json +	',"Fecha_QA":"' + CONVERT(VARCHAR(25), @Fecha_QA) +'"'
							SET @json =	@json +	',"Fecha_Venc":"' + CONVERT(VARCHAR(25), @Fecha_Venc) +'"'
							SET @json =	@json +	'}'

							EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Fac_Generar_Item @json

							IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
							BEGIN
								RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar_Item', 16,  1 ) 
							END

							SET @Contador = @Contador + 1;
						END

				------------------------------------------ FIN GENERACION DE ITEMS FACTURA -------------------------------------------

				---------------------------------------------------- FACTURA FIN  ----------------------------------------------------

					IF(@pModoDebug = 1)
					BEGIN
						PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Fin'
					END
				
						SET @json =	'{'
						SET @json =	@json + '"FlagUsarTrans":"1"'
						SET @json =	@json +	',"ModoDebug":"0"'
						SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Fac) +'"'
						SET @json =	@json +	'}'

						EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Fac_Fin @json

						IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
						BEGIN
							RAISERROR ('Error when calling CPJ_Cbtes_Fac_Fin', 16,  1 ) 
						END

				END
			END
			-------------------------------------------------- FIN FACTURA FIN  ----------------------------------------------------

			------------------------------------------------ GENERACION DE RECIBO --------------------------------------------------

				IF(@pModoDebug = 1)
				BEGIN
					PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Rec_Generar'
				END
				
				SET @JSON_Parametros_Stored_Invocado =	'{' +
													dbo.CF_Json_ParsearVariable('FlagUsarTrans', @pFlagUsarTrans, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Usuario', -1, 'SMALLINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Cliente', @pId_Cliente, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Periodo_Caja', @Id_Periodo_Caja, 'SMALLINT') + ',' +
													dbo.CF_Json_ParsearVariable('Fecha', GETDATE(), 'DATETIME') + ',' +
													dbo.CF_Json_ParsearVariable('Importe', @Importe, 'DECIMAL(20,2)') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Tipo_Cbte', @Id_Tipo_Cbte_Rec, 'CHAR(4)') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Moneda', @Id_Moneda, 'CHAR(3)') + ',' +
													dbo.CF_Json_ParsearVariable('Cotizacion', 1, 'DECIMAL(12,4)') + ',' +
													dbo.CF_Json_ParsearVariable('Lote', @Nro_Operacion, 'VARCHAR(20)') +
													dbo.CF_Json_ParsearVariable('Omitir_Resultado_OK', 1, 'TINYINT') +
													'}'

			SET @Id_Trans_Rec = 0
			EXEC @Result_Stored_Invocado = CPJ_Cbtes_Rec_Generar @JSON_Parametros_Stored_Invocado

			IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
			BEGIN
				RAISERROR ('Error when calling CPJ_Cbtes_Rec_Generar', 16,  1 ) 
			END
			ELSE
			BEGIN
				SELECT TOP 1 @Id_Trans_Rec = Id_Trans
				FROM Cbtes 
				WHERE Lote = @Nro_Operacion
				AND Id_Cliente = @pId_Cliente
				ORDER BY Id_Trans DESC
			END
			
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Id_Trans_Rec: ' + CAST(@Id_Trans_Rec AS VARCHAR(10))
			END

			--------------------------------------------- FIN GENERACION DE RECIBO --------------------------------------------------

			------------------------------------------- GENERACION DE ITEMS RECIBO --------------------------------------------------

			IF(@Id_Trans_Rec > 0)
			BEGIN

				IF(@pModoDebug = 1)
				BEGIN
					PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Rec_Generar_Item'
				END
				
				SET @Contador = 1

				WHILE @Contador <= @Cant
				BEGIN
					
					IF (@Tipo_Operacion <> 'P')
					BEGIN
						SET @Id_Trans_Fac = (SELECT dbo.CF_JSON_VALUE(ColumnA,'id_trans') FROM #TABLE WHERE Id = @Contador)
						SET @Importe_Rec  = (SELECT dbo.CF_JSON_VALUE(ColumnA,'importe') FROM #TABLE WHERE Id = @Contador)
					END

					SET @JSON_Parametros_Stored_Invocado =	'{' +
															dbo.CF_Json_ParsearVariable('FlagUsarTrans', @pFlagUsarTrans, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans_Rec, 'INT') + ',' +
															dbo.CF_Json_ParsearVariable('Item', @Contador, 'SMALLINT') + ',' +
															dbo.CF_Json_ParsearVariable('Cantidad', 1, 'DECIMA(12,5)') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Trans_A_Cancelar', @Id_Trans_Fac, 'INT') + ',' +
															dbo.CF_Json_ParsearVariable('Importe_A_Cancelar', @Importe_Rec, 'DECIMAL(20,2)') + 
															'}'

					EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Rec_Generar_Item @JSON_Parametros_Stored_Invocado

					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
					BEGIN
						RAISERROR ('Error when calling CPJ_Cbtes_Rec_Generar_Item', 16,  1 ) 
					END

					SET @Contador = @Contador + 1;
				END

			---------------------------------------- FIN GENERACION DE ITEMS RECIBO --------------------------------------------------

			------------------------------------------ GENERACION DE PAGO RECIBO -----------------------------------------------------

				IF(@pModoDebug = 1)
				BEGIN
					PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Rec_Generar_Pago'
				END

					SET @json =	'{'
					SET @json =	@json + '"FlagUsarTrans":"' + CONVERT(VARCHAR(10), @pFlagUsarTrans) +'"'
					SET @json =	@json +	',"ModoDebug":"' + CONVERT(VARCHAR(10), @pModoDebug) +'"'
					SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Rec) +'"'
					SET @json =	@json +	',"Id_Tipo_Val":"' + CONVERT(VARCHAR(3), 'DB') +'"'
					SET @json =	@json +	',"Valor_Nro":"' + CONVERT(VARCHAR(10), 1) +'"'
					SET @json =	@json +	',"Fecha_Val":"' + CONVERT(VARCHAR(25), GETDATE()) +'"'
					SET @json =	@json +	',"Fecha_Emision":"' + CONVERT(VARCHAR(25), GETDATE()) +'"'
					SET @json =	@json +	',"Fecha_Acreditacion":"' + CONVERT(VARCHAR(25), GETDATE()) +'"'
					SET @json =	@json +	',"Fecha_Vence":"' + CONVERT(VARCHAR(25), GETDATE()) +'"'
					SET @json =	@json +	',"Importe":"' + CONVERT(VARCHAR(20), @Importe, 112) +'"'
					SET @json =	@json +	',"Id_Cta_banco":"' + CONVERT(VARCHAR(10), @Id_Cta_banco) +'"'
					SET @json =	@json +	'}'

					EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Rec_Generar_Pago @json

					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
					BEGIN
						RAISERROR ('Error when calling CPJ_Cbtes_Rec_Generar_Pago', 16,  1 ) 
					END

				--------------------------------------- FIN GENERACION DE PAGO RECIBO -----------------------------------------------------

				------------------------------------------------- RECIBO FIN  -------------------------------------------------------------

				IF(@pModoDebug = 1)
				BEGIN
					PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Rec_Fin'
				END

					SET @json =	'{'
					SET @json =	@json + '"FlagUsarTrans":"1"'
					SET @json =	@json +	',"ModoDebug":"0"'
					SET @json =	@json +	',"Id_Trans":"' + CONVERT(VARCHAR(10), @Id_Trans_Rec) +'"'
					SET @json =	@json +	'}'

					EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Rec_Fin @json

					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 
					BEGIN
						RAISERROR ('Error when calling CPJ_Cbtes_Rec_Fin', 16,  1 ) 
					END

				----------------------------------------------- FIN RECIBO FIN  -------------------------------------------------------------
				
				DROP TABLE #TABLE
			END
			UPDATE WebProcesos SET Id_Estado = 2 WHERE Id_Web_Proceso = @Id_Web_Proceso 
			SELECT 1 AS Completo
		END
		ELSE
		BEGIN
			UPDATE WebProcesos SET Id_Estado = 6 WHERE Id_Web_Proceso = @Id_Web_Proceso 
			SELECT 1 AS Completo
		END
	END
	ELSE
	BEGIN
		
		SET @Id_Web_Proceso = ISNULL((SELECT MAX(Id_Web_Proceso)
							  FROM WebProcesos W
							  WHERE DATEADD(SECOND, -60, GETDATE()) <= W.Fecha_Procesamiento
							  AND ISNULL(dbo.CF_JSON_VALUE(CAST(W.Json AS NVARCHAR(MAX)), '$.productos[0].id_cliente'),W.Id_Cliente) = @pId_Cliente
							  AND W.Id_Cliente = @pId_Cliente_Titular
							  AND W.Id_Estado = 1
							  AND W.Fecha_Creacion >= '20230801'
							  GROUP BY Id_Web_Proceso),0)

		IF (@Id_Web_Proceso > 0) 
		BEGIN
			
			SELECT @Json = Json, @Nro_Operacion = Nro_Operacion
			FROM WebProcesos
			WHERE Id_Web_Proceso = @Id_Web_Proceso

			SET @Json_Prod = ISNULL(CONVERT(VARCHAR(MAX), dbo.CF_JSON_VALUE(@Json, 'productos')), '')
			SELECT * INTO #TABLEPROC FROM dbo.CF_Split(@Json_Prod, '},')
    
			SET @Cant = (SELECT COUNT(*) FROM #TABLEPROC)

			CREATE TABLE #TABLEPROC2 (Nro_Operacion VARCHAR(20), Id_Cliente INT, Descripcion VARCHAR(150), Razon_Social VARCHAR(100))

			WHILE @Contador <= @Cant
			BEGIN
				SET @Descripcion = (SELECT dbo.CF_JSON_VALUE(ColumnA, 'descripcion') FROM #TABLEPROC WHERE Id = @Contador)
				SET @Id_Cliente = (SELECT dbo.CF_JSON_VALUE(ColumnA, 'id_cliente') FROM #TABLEPROC WHERE Id = @Contador)
				SET @Razon_Social = (SELECT dbo.CF_JSON_VALUE(ColumnA, 'razon_social') FROM #TABLEPROC WHERE Id = @Contador)

				INSERT INTO #TABLEPROC2 (Nro_Operacion, Id_Cliente, Descripcion, Razon_Social)
				VALUES (@Nro_Operacion, @Id_Cliente, @Descripcion, @Razon_Social)

				SET @Contador = @Contador + 1
			END

			SELECT * FROM #TABLEPROC2

			DROP TABLE #TABLEPROC
			DROP TABLE #TABLEPROC2
		END
		ELSE
		BEGIN
			
			IF @pModoDebug = 1
			BEGIN
				PRINT 'El Socio : '	+ CAST(@pId_Cliente AS VARCHAR(10)) + ' No posee un Proceso en Estado 1'
			END
		END

	END

END
